## this script is for calculation of inter-observer reliability for play behaviour during holeboard testing sessions
# observers: Celine and Thomas
# measures: see play ethogram
# date of inter-observer reliability: May 2024


# install package

install.packages("irr")
library(irr)
install.packages("psych")
library(psych)

# import dataset

IOR_file <- read.csv("C:/Users/ou22669/OneDrive - University of Bristol/University of Bristol/Holeboard/Datasets/Inter reliability test_holeboard_C_T.csv")
IOR_file

# run one ICC per behaviour 

ICC_score_run <- icc(IOR_file[c("Run_T", "Run_C")], model = "twoway", type = "agreement", unit = "single")
# 0.98
ICC_score_jump <- icc(IOR_file[c("Jump_T", "Jump_C")], model = "twoway", type = "agreement", unit = "single")
# 0.92
ICC_score_kick <- icc(IOR_file[c("Kick_T", "Kick_C")], model = "twoway", type = "agreement", unit = "single")
# ^ kick one is neg value?? - maybe not enough values to run the test? -- exclude?
ICC_score_buck <- icc(IOR_file[c("Buck_T", "Buck_C")], model = "twoway", type = "agreement", unit = "single")
# 0.65
ICC_score_rear <- icc(IOR_file[c("Rear_T", "Rear_C")], model = "twoway", type = "agreement", unit = "single")
# 0.40 -- rear excluded
ICC_score_headshake <- icc(IOR_file[c("Head_shake_T", "Head_shake_C")], model = "twoway", type = "agreement", unit = "single")
# 0.73

# mean of the scores except for kick

numbers <- c(0.98, 0.92, 0.65, 0.4, 0.73)


mean_value <- mean(numbers)


print(mean_value)


print(ICC_score_run)
print(ICC_score_buck)
print(ICC_score_kick)
print(ICC_score_jump)
print(ICC_score_headshake)
print(ICC_score_rear)
